# Ćwiczenie 1

## Zadanie
Program w postaci prostego kalkulatora nie obsługuje błędu powstającego podczas dzielenia przez zero. Zmodyfikuj sygnaturę funkcji operacji matematycznych w taki sposób, aby zwracały wartości typu `int` i `error`. Jeżeli we funkcji `div` dzielnik wynosi `0`, wartością zwrotną dla błędu powinno być `errors.New("division by zero")`. We wszystkich pozostałych przypadkach wartością zwrotną dla błędu powinna być `nil`. Dostosuj kod funkcji `main`, aby sprawdzał pod kątem wymienionego błędu.

## Rozwiązanie
Funkcje operacji matematycznych zmień na następujące:

```go
func add(i int, j int) (int, error) { return i + j, nil }

func sub(i int, j int) (int, error) { return i - j, nil }

func mul(i int, j int) (int, error) { return i * j, nil }

func div(i int, j int) (int, error) {
    if j == 0 {
        return 0, errors.New("division by zero")
    }
    return i / j, nil
}
```

Deklarację `opMap` zmień na tutaj przedstawioną:

```go
var opMap = map[string]func(int, int) (int, error){
	"+": add,
	"-": sub,
	"*": mul,
	"/": div,
}
```

Ponadto potrzebna jest zmienna dla każdej wartości zwrotnej, gdy będzie wywoływana funkcja `opFunc`:

```go
		result, err := opFunc(p1, p2)
		if err != nil {
			fmt.Println(err)
			continue
		}
        fmt.Println(result)
```

Dobrą praktyką jest dodawanie testów, aby upewnić się o poprawności wprowadzonych zmian.